#include <PID_v1.h>
#include <I2Cdev.h>
#include <Wire.h>
#include <MPU6050_6Axis_MotionApps20.h>
#include <LMotorController.h>
#include <looper.h>


#define SERIAL_BUFFER_SIZE 128


#define MIN_ABS_SPEED 1 //min rychlost
#define PRINT_SERIAL 1   // povoleni/zakazani vypisu na serial
#define PID_MANUAL 1     // rucni nastaveni PID pres potenciometry 

#define BACK -1
#define FORW 1


// Motor PINS
// motor 1
int enA = 3;
int in1 = 5;
int in2 = 6;
// motor 2
int enB = 9;
int in3 = 10;
int in4 = 11;


//LMotorController motorController(enA, in1, in2, enB, in3, in4, 0.83, 1); //  prave,leve - nakonci konstanty , aby motory tocili stejne - pokud nepojede rovne potraba doladit
LMotorController motorController(enA, in1, in2, enB, in3, in4, 0.92, 1); //  prave,leve - nakonci konstanty , aby motory tocili stejne - pokud nepojede rovne potraba doladit

int LED = 13;
bool stav_led=0;
int TEST_LED_GREEN = 7;
int TEST_LED_RED = 12;

//vstupy z potenciometru
int nastavKp = A1;
int nastavKi = A2;
int nastavKd = A3;


float angle, angular_rate, actAngle;

double Input, Output, input;
double Setpoint = 0;
double Kp = 58;
double Ki = 255;
double Kd = 1;
double prevKp, prevKi, prevKd;
double potKp, potKi, potKd;

PID myPID(&Input, &Output, &Setpoint, Kp, Ki, Kd, DIRECT);


//PRO GYRO
MPU6050 mpu;
bool dmpReady = false;  // když je DPM připraveno, obsahuje true
uint8_t mpuIntStatus;   // stav externího přerušení z DPM
uint8_t devStatus;      // stav poslední operace
uint16_t packetSize;    // velikost paketu z DPM
uint16_t fifoCount;     // počet bytů ve FIFO zásobníku
uint8_t fifoBuffer[64]; // FIFO zásobník
// proměnné důležité pro výpočet
Quaternion q;           // [w, x, y, z]         kvaternion
VectorFloat gravity;    // [x, y, z]            vektor setrvačnosti
float ypr[3];           // [yaw, pitch, roll]   yaw/pitch/roll úhly
int16_t gyro[3];      // [x, y, z] gyros container
//preruseni PIN2
volatile bool mpuInterrupt = false;     // true pokud DMP vyvolalo přerušení
void dmpDataReady() {
  mpuInterrupt = true;;
}

int STD_LOOP_TIME = 50;
int lastLoopTime = STD_LOOP_TIME;
int lastLoopUsefulTime = STD_LOOP_TIME;
unsigned long loopStartTime = 0;

//LOOPER
looper myScheduler;

void setup()
{
  
  Wire.begin();
  TWBR = 24; // 400kHz I2C clock
  //TWBR = ((F_CPU / 100000L) - 16) / 2; // Set I2C frequency to 100kHz
  Serial.begin(115200);
  
  // Inicializace gyra
  Serial.println("Initializing I2C devices...");
  mpu.initialize();
  //nastaveni
  mpu.setFullScaleGyroRange(MPU6050_GYRO_FS_250);  //±250°/sec
  mpu.setFullScaleAccelRange(MPU6050_ACCEL_FS_2);  //±2g
  mpu.setClockSource(MPU6050_CLOCK_PLL_XGYRO);
  
  // ověříme připojení k MPU-6050
  Serial.println(F("Testing device connections..."));
  Serial.println(mpu.testConnection() ? F("MPU6050 connection successful") : F("MPU6050 connection failed"));


  // incializujeme DMP
  Serial.println(F("Initializing DMP..."));
  devStatus = mpu.dmpInitialize();


  // nastaveni offsetu - kalibrace -  supply your own gyro offsets here, scaled for min sensitivity
  //mpu.setXAccelOffset(1432);
  //mpu.setYAccelOffset(-50);
  //mpu.setZAccelOffset(-255);
  //mpu.setXGyroOffset(15);
  //mpu.setYGyroOffset(0);
  //mpu.setZGyroOffset(-3);  
  
  // ujistíme se, že funguje
  if (devStatus == 0) {
      // zapneme DMP
      Serial.println(F("Enabling DMP..."));
      mpu.setDMPEnabled(true);
  
      // externí přerušení Arduina nabindujeme na funkci dmpDataReady
      Serial.println(F("Enabling interrupt detection (Arduino external interrupt 0)..."));
      attachInterrupt(0, dmpDataReady, RISING);
      digitalWrite(2, HIGH);  //turn on pull up resistor for flow sensor on pin 2
      
      mpuIntStatus = mpu.getIntStatus();
  
      Serial.println(F("DMP ready! Waiting for first interrupt..."));
      dmpReady = true;
  
      // zjistíme si, jak velké pakety DMP vrací
      packetSize = mpu.dmpGetFIFOPacketSize();
  } else {
      // Když dojde k chybě, tak:
      // 1 = selhala úvodní komunikace s DMP
      // 2 = selhala aktualizace nastavení DMP
      Serial.print(F("DMP Initialization failed (code "));
      Serial.print(devStatus);
      Serial.println(F(")"));
  }

  //nastaveni ovladani motorum
  pinMode(enA, OUTPUT);
  pinMode(enB, OUTPUT);
  pinMode(in1, OUTPUT);
  pinMode(in2, OUTPUT);
  pinMode(in3, OUTPUT);
  pinMode(in4, OUTPUT);
  pinMode(LED, OUTPUT);
  pinMode(TEST_LED_GREEN, OUTPUT);
  pinMode(TEST_LED_RED, OUTPUT);
  
  myPID.SetMode(AUTOMATIC);
  myPID.SetSampleTime(5); //default 200ms
  myPID.SetOutputLimits(-255, 255);
  readManualPID();
  
//  myScheduler.addJob(status,100);
  myScheduler.addJob(readManualPID,1000);
  
}


void readManualPID() //manualni nastaveni PID z potenciometru A0,A1,A2
{
  #if PID_MANUAL
    potKp = analogRead(nastavKp);
    potKi = analogRead(nastavKi);
    potKd = analogRead(nastavKd);
    Kp = map(potKp, 0, 1023, 0, 25000) / 100.0; //0 - 250
    Ki = map(potKi, 0, 1023, 0, 100000) / 100.0; //0 - 1000
    Kd = map(potKd, 0, 1023, 0, 500) / 100.0; //0 - 5
    
    if (Kp != prevKp || Ki != prevKi || Kd != prevKd)
    {
      myPID.SetTunings(Kp, Ki, Kd);
      prevKp = Kp; prevKi = Ki; prevKd = Kd;
    }
  #endif
}

void status()
{
  if (stav_led==0) {
    digitalWrite(LED, HIGH);
    stav_led=1;
  } else {
    digitalWrite(LED, LOW);
    stav_led=0;
  }
}

void loop()
{
//     motorController.move(-250, MIN_ABS_SPEED);
      //NACTENI DAT Z GYRA
      if (!dmpReady) return;

    while (!mpuInterrupt && fifoCount < packetSize) { 
        
        status();
        myPID.Compute();
        
        
#if PRINT_SERIAL
        Serial.print(" | Input = ");Serial.print(Input);
        Serial.print(" | Output = ");Serial.print(Output);
        Serial.print(" | Kp = ");Serial.print(Kp);
        Serial.print(" | Ki = ");Serial.print(Ki);
        Serial.print(" | Kd = ");Serial.println(Kd);

#endif    
         
         if (millis() > 7000) {
             motorController.move(Output, MIN_ABS_SPEED);  
         }
         if (angle>0) {analogWrite(TEST_LED_RED,0);analogWrite(TEST_LED_GREEN,255);}
         if (angle<0) {analogWrite(TEST_LED_RED,255);analogWrite(TEST_LED_GREEN,0);}         
         if (angle==0) {analogWrite(TEST_LED_RED,0);analogWrite(TEST_LED_GREEN,0);}  
  
         myScheduler.scheduler();       
      }

          
      // resetujeme proměnnou informující o přerušení vyvolané z DMP a získáme INT_STATUS byte
      mpuInterrupt = false;
      mpuIntStatus = mpu.getIntStatus();
      
      // získáme velikost FIFO zásobníku
      fifoCount = mpu.getFIFOCount();
      
      // zjistíme, zda nedošlo k přetečené zásobníku
      // pokud k němu dojde, je třeba optimalizovat kód v cyklu výše,
      // případně přerušit provádění mezi delšími výpočty, je-li to třeba
      if ((mpuIntStatus & 0x10) || fifoCount == 1024) {
          // vyčistíme zásobník
          mpu.resetFIFO();
          Serial.println(F("FIFO overflow!"));
      
      // pokud je vše v pořádku, zpracujeme data z DMP
      } else if (mpuIntStatus & 0x02) {
          // čekání na správnou délku dat
          while (fifoCount < packetSize) fifoCount = mpu.getFIFOCount();
      
          // přečteme paket ze zásobníku
          mpu.getFIFOBytes(fifoBuffer, packetSize);
      
          // pokud je v zásobníku víc než jeden paket, tímto zajistíme, že bude přečten v dalším cyklu
          fifoCount -= packetSize;
      
          // naplnění proměnných s vypočítanými hodnotami
          mpu.dmpGetQuaternion(&q, fifoBuffer);
          mpu.dmpGetGravity(&gravity, &q);
          mpu.dmpGetYawPitchRoll(ypr, &q, &gravity);
          //mpu.dmpGetGyro(gyro, fifoBuffer);
      
          //Výpis YAW/PITCH/ROLL
          //Serial.print("ypr\t");
          //Serial.print(ypr[0] * 180/M_PI);
          //Serial.print("\t");
          //Serial.print(ypr[1] * 180/M_PI);
          //Serial.print("\t");
          //Serial.println(ypr[2] * 180/M_PI);
          
          //Serial.print(" | YPR[1]: ");Serial.print(ypr[1]);
          //Serial.print(" | Gyros[1]:");Serial.println(gyros[1]);
        
          angle = (ypr[1] * RAD_TO_DEG);          // Uhlel ve stupnich 
          //angular_rate = gyro[1];               // uhlova rychlost ve stupnich
                
          //Input=angle-0.85;                          //nutno zkalibrovat == mam to sikmo
          Input=angle-1.5;                         //nutno zkalibrovat == mam to sikmo
       
      }


}
